define([
    'models/singleton-model',
    'models/resources-collection',
], function(
    Model,
    Resources
) {
    'use strict';

    var User = Model.extend({
        resourceName: 'mhpuser',
        defaults: {
            'lastName': '',
            'firstName': '',
            'displayName': '',
            'rightOfAccessAccepted': false,
            'link': '',
            'vistaLocation': '',
            'facilityName': '',
        },
        hasAcceptedROA: function() {
            return this.get('rightOfAccessAccepted');
        },
        parse: function (response) {
            var mhpUser = response.mhpUser;

            mhpUser.links = new Resources(response.link);

            mhpUser.displayName = mhpUser.lastName + ', ' + mhpUser.firstName;

            delete mhpUser.link;

            return mhpUser;
        },
    });

    return new User();
});
